function OrganizedData = SubpopulationsOfPatients(ALLData)

Name_Edit = ALLData.Dateiname;
Surv_Edit = ALLData.Surv;
Status_Edit = ALLData.Status;
Tissue_to_Subpopulation = ALLData.Var2;
n_subpop = unique(Tissue_to_Subpopulation);

L = length(unique(Name_Edit));
CompactSubpop = zeros(L,n_subpop);

LIST_IDs = [];
clear counter
counter = 1;

for i=1:length(Name_Edit)

Check = strfind(Name_Edit, Name_Edit{i});
IND = find(~cellfun(@isempty,Check));
TF = any(ismember(IND,LIST_IDs));
if ( TF == 0)
LIST_IDs = [LIST_IDs; IND];
censorship(counter) = unique(Status_Edit(IND));
survivor(counter) = unique(Surv_Edit(IND));
CompactSubpop(counter,Tissue_to_Subpopulation(IND)) = Tissue_to_Subpopulation(IND);
else
continue
end

counter = counter + 1;
end

OrganizedData = [CompactSubpop,survivor',censorship'];